using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class VTA_PATIENTDB : DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public VTA_PATIENTDB()
        {
        }

		#endregion

		#region Properties
		#endregion

		#region Methods

		public VTA_PATIENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_ID)
		{
			VTA_PATIENT objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_VTA_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public VTA_PATIENT GetPatientVTAInfoByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int Patient_ID)
        {
            VTA_PATIENT objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_VTA_PATIENT_getitemByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, Patient_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<VTA_PATIENT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<VTA_PATIENT> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_VTA_PATIENT_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VTA_PATIENT objSave)
		{
			Int32? objReturn = objSave.VTA_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_VTA_PATIENT_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.Address_line1, objSave.Address_line2, objSave.Address_line3, objSave.City, objSave.Country, objSave.County, objSave.Dateofbirth, objSave.Dateofdeath, objSave.Email_address, objSave.Ethnic_code, objSave.Gender_code, objSave.Home_phone, objSave.IsEFRPatient, objSave.Maritalstatus_code, objSave.Oefoifindicator, objSave.Patient_ID, objSave.PatientAddress, objSave.Patientfirstname, objSave.Patienticn, objSave.Patientlastname, objSave.Patientmiddlename, objSave.PatientName, objSave.Patientsnum, objSave.Race_code, objSave.State, objSave.Svcbranch_code, objSave.Vpid_number, ref objReturn, objSave.Work_phone, objSave.ZIP, objSave.ZIP_PLUS_4);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_VTA_PATIENT_delete(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<STD_ICD9> SelectICD9CodesByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 Patient_ID)
        {
            List<STD_ICD9> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_ICD9_getitemsByPatientID(CURRENT_USER, CURRENT_REGISTRY_ID, Patient_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<VTA_PATIENT_SOAP_KEYWORD> SelectSoapNoteByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 Patient_ID)
        {
            List<VTA_PATIENT_SOAP_KEYWORD> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_VTA_PATIENT_SOAP_KEYWORD_getitemsByPatientID(CURRENT_USER, CURRENT_REGISTRY_ID, Patient_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
